﻿using Microsoft.Extensions.DependencyInjection;
using ORC.TF.Custom.AdventureWorksSample.Facades;
using ORC.TF.Custom.AdventureWorksSample.Interfaces;
using ORC.TF.Custom.AdventureWorksSample.Repositories;
using System;

namespace ORC.TF.Custom.AdventureWorksSample
{
    public class Dependencies
    {
        public static IServiceProvider Provider { get; private set; }

        internal static IServiceProvider Register(IServiceCollection services, string dbConnStr)
        {
            string environment = Environment.GetEnvironmentVariable("ASPNETCORE_ENVIRONMENT") ?? "Development";
            bool isDevelopmentBuild = environment == "Development";

            services.AddTransient<IEmployeeReader>(provider => new EmployeeReader(dbConnStr));
            services.AddTransient<IEmployeeWriter>(provider => new EmployeeWriter(dbConnStr));
            services.AddTransient<IProductsReader>(provider => new ProductsReader(dbConnStr));

            services.AddTransient<IEmployeeFacade, EmployeeFacade>();
            services.AddTransient<IProductsFacade, ProductsFacade>();

            Provider = services.BuildServiceProvider(isDevelopmentBuild);

            return Provider;
        }
    }
}
