﻿using ORC.TF.Custom.AdventureWorksSample.Interfaces;
using ORC.TF.Custom.AdventureWorksSample.Models;

namespace ORC.TF.Custom.AdventureWorksSample.Facades
{
    public class EmployeeFacade : IEmployeeFacade
    {
        private readonly IEmployeeReader _employeeReader;
        private readonly IEmployeeWriter _employeeWriter;

        public EmployeeFacade(IEmployeeReader employeeReader, IEmployeeWriter employeeWriter)
        {
            _employeeReader = employeeReader;
            _employeeWriter = employeeWriter;
        }

        public IEmployee GetEmployeeInfo(string userName)
        {
            var employee = new Employee();

            var info = _employeeReader.LoadInfo(userName);

            employee.LoginID = info.LoginID;
            employee.HireDate = info.HireDate.ToString();
            employee.VacationHours = info.VacationHours;
            employee.SickLeaveHours = info.SickLeaveHours;

            var department = _employeeReader.LoadDepartment(userName);

            employee.Department.GroupName = department.GroupName;
            employee.Department.Name = department.DeptName;

            return employee;
        }

        public void UpdateAvailableHours(string userName, Hours hoursType, int newHours)
        {
            if(hoursType == Hours.Sick)
            {
                _employeeWriter.UpdateSickHours(userName, newHours);
            }

            if(hoursType == Hours.Vacation)
            {
                _employeeWriter.UpdateVacationHours(userName, newHours);
            }
        }
    }
}
