﻿using ORC.TF.Custom.AdventureWorksSample.Interfaces;
using System.Collections.Generic;

namespace ORC.TF.Custom.AdventureWorksSample.Facades
{
    public class ProductsFacade : IProductsFacade
    {
        private readonly IProductsReader _productsReader;

        public ProductsFacade(IProductsReader productsReader)
        {
            _productsReader = productsReader;
        }

        public IDictionary<string, IList<IProduct>> GetCategoryProducts(string categoryName)
        {
            var results = new Dictionary<string, IList<IProduct>>();

            var products = _productsReader.LoadProducts(categoryName);

            foreach(var product in products)
            {
                if (results.ContainsKey(product.SubCategory))
                {
                    results[product.SubCategory].Add(product);
                }
                else
                {
                    results.Add(product.SubCategory, new List<IProduct> { product });
                }
            }

            return results;
        }
    }
}
