﻿using Microsoft.AspNetCore.Mvc;
using OpenRoad.ThoughtFarmer.Core.Configuration;
using OpenRoad.ThoughtFarmer.Core.Localization;
using OpenRoad.ThoughtFarmer.Core.UI;
using OpenRoad.ThoughtFarmer.Shared.Core.Security;
using ORC.TF.Custom.AdventureWorksSample.Interfaces;
using ORC.TF.Custom.Authentication;
using ORC.TF.Data;
using ORC.TF.Logging;
using System;
using System.Collections.Generic;

// For more information on enabling MVC for empty projects, visit https://go.microsoft.com/fwlink/?LinkID=397860

namespace ORC.TF.Custom.AdventureWorksSample
{
    [Route("api/[controller]")]
    public class ProductsController : CustomCardApiBaseController
    {
        private const string Category = "category";
        private const string ContentId = "contentId";
        private readonly IProductsFacade _productsFacade;

        public ProductsController(ICurrentUserProvider currentUserProvider, ConfigurationSettings config,
            ILocalizedLabels localizedLabels, Theme theme, QueryAssistant queryAssistant,
            ApiAssistant apiAssistant, ILogging log, CookieCrypto cookieCrypto, IProductsFacade productsFacade)
            : base(currentUserProvider, config, localizedLabels, theme, queryAssistant, apiAssistant, log, cookieCrypto)
        {
            _productsFacade = productsFacade;
        }

        [HttpGet]
        public IActionResult Get()
        {
            if (CurrentUser != null && CurrentUser.UserId > 0)
            {
                var configuration = GetCardConfiguration();

                if (configuration != null)
                {                    
                    string category = GetCategory(configuration);                
                    return Ok(new { Category = category });
                }

                throw new ArgumentException("contentId invalid");
            }

            return NotFound();
        }

        [HttpGet("list/{categoryName}")]
        public IActionResult GetList(string categoryName)
        {
            if (CurrentUser != null && CurrentUser.UserId > 0)
            {
                var products = _productsFacade.GetCategoryProducts(categoryName);

                return Ok(products);
            }

            return NotFound("User not found");
        }

        private int GetContentId(IDictionary<string, object> configuration)
        {
            if (configuration.ContainsKey(ContentId))
            {
                return Convert.ToInt32(configuration[ContentId]);
            }

            throw new ArgumentException("contentId invalid");
        }

        private string GetCategory(IDictionary<string, object> configuration)
        {
            if (configuration.ContainsKey(Category))
            {
                return configuration[Category].ToString();
            }

            throw new ArgumentException("category invalid");
        }
    }
}
