﻿using Dapper;
using ORC.TF.Custom.AdventureWorksSample.Interfaces;
using System.Data.SqlClient;
using System.Linq;

namespace ORC.TF.Custom.AdventureWorksSample.Repositories
{
    public class EmployeeReader : IEmployeeReader
    {
        private readonly string _connectionString;

        public EmployeeReader(string connectionString)
        {
            _connectionString = connectionString;
        }

        public dynamic LoadInfo(string userName)
        {
            const string sql = @"select top 1 LoginID, HireDate, VacationHours, SickLeaveHours
                        from HumanResources.Employee
                        where LoginID = @userName";

            using (var conn = new SqlConnection(_connectionString))
            {
                conn.Open();

                return conn.Query<dynamic>(sql, new { userName = userName }).FirstOrDefault();
            }
        }

        public dynamic LoadDepartment(string userName)
        {
            const string sql = @"select top 1 HR_D.GroupName, HR_D.[Name] as DeptName 
                        from HumanResources.EmployeeDepartmentHistory HR_EDH
                        inner join HumanResources.Employee HR_E
                        on HR_EDH.BusinessEntityID = HR_E.BusinessEntityID
                        inner join HumanResources.Department HR_D
                        on HR_EDH.DepartmentID = HR_D.DepartmentID
                        where HR_EDH.EndDate is null
                        and HR_E.LoginID = @userName";

            using (var conn = new SqlConnection(_connectionString))
            {
                conn.Open();

                return conn.Query<dynamic>(sql, new { userName = userName }).FirstOrDefault();
            }
        }
    }
}
