﻿using Dapper;
using ORC.TF.Custom.AdventureWorksSample.Interfaces;
using System.Data.SqlClient;

namespace ORC.TF.Custom.AdventureWorksSample.Repositories
{
    public class EmployeeWriter : IEmployeeWriter
    {
        private readonly string _connectionString;

        public EmployeeWriter(string connectionString)
        {
            _connectionString = connectionString;
        }

        public void UpdateSickHours(string userName, int newHours)
        {
            const string sql = "update HumanResources.Employee set SickLeaveHours = @sickHours where LoginID = @userName";

            using (var conn = new SqlConnection(_connectionString))
            {
                conn.Open();

                conn.Execute(sql, new { userName = userName, sickHours = newHours });
            }
        }

        public void UpdateVacationHours(string userName, int newHours)
        {
            const string sql = "update HumanResources.Employee set VacationHours = @vacationHours where LoginID = @userName";

            using (var conn = new SqlConnection(_connectionString))
            {
                conn.Open();

                conn.Execute(sql, new { userName = userName, vacationHours = newHours });
            }
        }
    }
}
