﻿using Microsoft.AspNetCore.Builder;
using Microsoft.AspNetCore.Hosting;
using Microsoft.Extensions.Configuration;
using Microsoft.Extensions.DependencyInjection;
using System;

namespace ORC.TF.Custom.AdventureWorksSample
{
    public class Startup : CustomStartup
    {
        private const string ConnectionStringKey = "AdventureWorks";
        private readonly string _dbConnStr;

        public Startup(IConfiguration config) : base(config)
        {
            _dbConnStr = config.GetConnectionString(ConnectionStringKey);
        }

        // This method gets called by the runtime. Use this method to add services to the container.
        // For more information on how to configure your application, visit https://go.microsoft.com/fwlink/?LinkID=398940
        public IServiceProvider ConfigureServices(IServiceCollection services)
        {
            Dependencies.Register(services, _dbConnStr);

            //tried to bundle the setup into a reusable method
            return CustomCardConfigureServices(services);
        }

        // This method gets called by the runtime. Use this method to configure the HTTP request pipeline.
        public void Configure(IApplicationBuilder app, IHostingEnvironment env)
        {
            //tried to bundle the setup into a reusable method
            CustomCardConfigure(app, env);
        }
    }
}
