﻿
var AdventureWorksProductsList = createReactClass({
    displayName: 'AdventureWorksProductsList',
    getInitialState: function () {
        return {
            products: null,
            isLoading: true
        };
    },
    componentDidMount: function () {
        this.loadData();
    },
    loadData: function () {
        var self = this;

        tf.api.newApiRequest(`/ccadventureworks/api/products/list/${this.props.category}`, {}, 'GET', function (response) {
            if (response.status === 200) {
                self.setState({ products: response.data, isLoading: false });
            }
        }, 'application/json');
    },
    render: function () {
        if(this.state.isLoading) {
            return <LoadingIndicator />;
        }        
        
        var rows = [];

        rows.push(<tr className="tfcc-header"><td colSpan="3" className="tfcc-title">Adventure Works {this.props.category}</td></tr>);

        for (const [key, value] of Object.entries(this.state.products)) {
            rows.push(<tr className="tfcc-product-header"><td colSpan="3" >{key}</td></tr>);

            for (var i = 0, len = value.length; i < len; i++) {
                var product = value[i];
                rows.push(<tr><td><strong>{product.productNumber}</strong></td><td>{product.productName}</td><td>${product.listPrice}</td></tr>);
            }
        }

        return <table width="100%" className="tfcc-adventure-works-products-table">{rows}</table>;
    }
});


if (portletServerResponse) {
    replaceView(<AdventureWorksProductsList ctx={ctx} category={portletServerResponse.category} />);
}