﻿using Microsoft.AspNetCore.Mvc;
using OpenRoad.ThoughtFarmer.Core.Configuration;
using OpenRoad.ThoughtFarmer.Core.Localization;
using OpenRoad.ThoughtFarmer.Core.UI;
using OpenRoad.ThoughtFarmer.Shared.Core.Security;
using ORC.TF.Custom.AdventureWorksSample.Interfaces;
using ORC.TF.Custom.AdventureWorksSample.Models;
using ORC.TF.Custom.Authentication;
using ORC.TF.Data;
using ORC.TF.Logging;

// For more information on enabling Web API for empty projects, visit https://go.microsoft.com/fwlink/?LinkID=397860

namespace ORC.TF.Custom.AdventureWorksSample
{
    [Route("api/[controller]")]
    public class EmployeeController : CustomCardApiBaseController
    {
        private readonly IEmployeeFacade _employeeFacade;

        public EmployeeController(ICurrentUserProvider currentUserProvider, ConfigurationSettings config,
            ILocalizedLabels localizedLabels, Theme theme, QueryAssistant queryAssistant,
            ApiAssistant apiAssistant, ILogging log, CookieCrypto cookieCrypto, IEmployeeFacade employeeFacade) 
            : base(currentUserProvider, config, localizedLabels, theme, queryAssistant, apiAssistant, log, cookieCrypto)
        {
            _employeeFacade = employeeFacade;
        }

        // GET: api/<controller>
        [HttpGet]
        public IActionResult Get()
        {
            if(CurrentUser != null && CurrentUser.UserId > 0)
            {
                return Ok(new { ContentId = CurrentUser.ContentId });
            }

            return NotFound();
        }

        [HttpGet("info")]
        public IActionResult GetInfo()
        {
            if (CurrentUser != null && CurrentUser.UserId > 0)
            {
                var employee = _employeeFacade.GetEmployeeInfo(CurrentUser.UserName);
                return Ok(employee);
            }

            return NotFound("User not found");
        }
        
        [HttpPost("sick")]
        public IActionResult TakeSickDay([FromBody]EmployeeHours employeeHours)
        {
            if (CurrentUser != null && CurrentUser.UserId > 0)
            {
                _employeeFacade.UpdateAvailableHours(CurrentUser.UserName, Hours.Sick, employeeHours.Hours);
                return Ok();
            }

            return NotFound("User not found");
        }

        [HttpPost("vacation")]
        public IActionResult TakeVacationDay([FromBody]EmployeeHours employeeHours)
        {
            if (CurrentUser != null && CurrentUser.UserId > 0)
            {
                _employeeFacade.UpdateAvailableHours(CurrentUser.UserName, Hours.Vacation, employeeHours.Hours);
                return Ok();
            }

            return NotFound("User not found");
        }
    }
}
