﻿using Dapper;
using ORC.TF.Custom.AdventureWorksSample.Interfaces;
using ORC.TF.Custom.AdventureWorksSample.Models;
using System.Collections.Generic;
using System.Data.SqlClient;
using System.Linq;

namespace ORC.TF.Custom.AdventureWorksSample.Repositories
{
    public class ProductsReader : IProductsReader
    {
        private readonly string _connectionString;

        public ProductsReader(string connectionString)
        {
            _connectionString = connectionString;
        }

        public IList<Product> LoadProducts(string categoryName)
        {
            const string sql = @"select p.[ProductID], p.[Name] as ProductName, p.ProductNumber,  p.ListPrice, psc.[Name] as SubCategory
                                from [Production].[Product] p
                                inner join [Production].[ProductSubcategory] psc
                                on p.ProductSubcategoryID = psc.ProductSubcategoryID
                                inner join [Production].[ProductCategory] pc
                                on psc.ProductCategoryID = pc.ProductCategoryID
                                where pc.[Name] = @categoryName
                                order by psc.[Name] asc, p.ListPrice desc";

            using (var conn = new SqlConnection(_connectionString))
            {
                conn.Open();

                return conn.Query<Product>(sql, new { categoryName = categoryName }).ToList();
            }
        }
    }
}
