
var AdventureWorksEmployeeInfo = createReactClass({
    displayName: 'AdventureWorksEmployeeInfo',
    getInitialState: function () {
        return {
            employee: null,
            isLoading: true
        };
    },
    componentDidMount: function () {
        this.loadData();
    },
    loadData: function () {
        var self = this;

        tf.api.newApiRequest('/ccadventureworks/api/employee/info', {}, 'GET', function (response) {
            if (response.status === 200) {
                self.setState({ employee: response.data, isLoading: false });
            }
        }, 'application/json');
    },
    canTakeVacation: function () {
        return this.state.employee.vacationHours >= 8;
    },
    onVacationClick: function () {
        var self = this;
        var currentEmployee = this.state.employee;
        currentEmployee.vacationHours = currentEmployee.vacationHours - 8;

        tf.api.newApiRequest('/ccadventureworks/api/employee/vacation', { hours: currentEmployee.vacationHours }, 'POST', function (response) {
            if (response.status === 200) {
                self.setState({ employee: currentEmployee });
            }
        }, 'application/json');
    },
    canTakeSick: function () {
        return this.state.employee.sickLeaveHours >= 8;
    },
    onSickClick: function () {
        var self = this;
        var currentEmployee = this.state.employee;
        currentEmployee.sickLeaveHours = currentEmployee.sickLeaveHours - 8;

        tf.api.newApiRequest('/ccadventureworks/api/employee/sick', {hours: currentEmployee.sickLeaveHours}, 'POST', function (response) {
            if (response.status === 200) {
                self.setState({employee: currentEmployee});
            }
        }, 'application/json');
    },
    render: function () {
        if(this.state.isLoading) {
            return <LoadingIndicator />;
        }

        return <div>
                <div className="tf-profile-field">
                    <div className="tf-profile-field-label">Department</div>
                    <div className="tf-profile-field-value">{this.state.employee.department.groupName} - {this.state.employee.department.name}</div>
                </div>
                <div className="tf-profile-field"><div className="tf-profile-field-label">Hire date</div><div className="tf-profile-field-value">{this.state.employee.hireDate}</div></div>
                <div className="tf-profile-field"><div className="tf-profile-field-label">Vacation hours available</div><div className="tf-profile-field-value">{this.state.employee.vacationHours}</div></div>
                <div className="tf-profile-field"><div className="tf-profile-field-label">Sick leave hours available</div><div className="tf-profile-field-value">{this.state.employee.sickLeaveHours}</div></div>
                <ButtonList leftAlign>
                    <Button onClick={this.onVacationClick} disabled={!this.canTakeVacation()}>
                        <i className="fa fa-plane" />Take vacation day
                    </Button>
                    <Button onClick={this.onSickClick} disabled={!this.canTakeSick()}>
                        <i className="fa fa-ambulance" />Take sick day
                    </Button>
                </ButtonList>
            </div>;
    }
});

if (portletServerResponse) {
    var currentPage = ctx.customPortlets.getPage();

    if (currentPage.pageType === tf.core.PageType.Profile && currentPage.contentId === portletServerResponse.contentId) {
        ctx.customPortlets.add(<AdventureWorksEmployeeInfo ctx={ctx} />, {
            css: portletCss,
            placement: tf.portlets.Placement.ProfileFieldGroups,
            label: 'Adventure Works'
        });
    }
}